﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class DebugCameraController : MonoBehaviour
{
    public bool IsEnabled;
    public float Speed = 0.1f;

    void Update()
    {
        if(IsEnabled)
        {
            if(Input.GetKey(KeyCode.UpArrow))
            {
                Camera.main.transform.position = new Vector3(Camera.main.transform.position.x, Camera.main.transform.position.y + (Speed * Time.deltaTime), ConfigurationManager.Instance.Core.CameraZPosition);
            }

            else if (Input.GetKey(KeyCode.DownArrow))
            {
                Camera.main.transform.position = new Vector3(Camera.main.transform.position.x, Camera.main.transform.position.y - (Speed * Time.deltaTime), ConfigurationManager.Instance.Core.CameraZPosition);
            }

            else if (Input.GetKey(KeyCode.RightArrow))
            {
                Camera.main.transform.position = new Vector3(Camera.main.transform.position.x + (Speed * Time.deltaTime), Camera.main.transform.position.y, ConfigurationManager.Instance.Core.CameraZPosition);
            }

            else if (Input.GetKey(KeyCode.LeftArrow))
            {
                Camera.main.transform.position = new Vector3(Camera.main.transform.position.x - (Speed * Time.deltaTime), Camera.main.transform.position.y, ConfigurationManager.Instance.Core.CameraZPosition);
            }
        }
    }
}
